***********************************************************************
*** Table F1: Sample split ***
************************************************************************  clear all 
clear all
use "$dataPath\Data"
do "$codePath\Transforming_variables"

regress global_credit_gap pcredit_gdp_gap
predict interak1, res

regress global_hp_gap hp_inc_gap
predict interak2, res

replace global_credit_gap = interak1
replace global_hp_gap = interak2

*** Column (1), Pre-2000: : Decomposed credit
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap i.country_id if year<=2000, robust cluster(period)
margins, dydx(dlogreal_pcredit  hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap) post
est store p1
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 14
estadd scalar Crisis = 13

*** Column (1), Post-1994: Decomposed credit
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap i.country_id if year>=1994, robust cluster(period)
margins, dydx(dlogreal_pcredit  hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap) post
est store p2
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 16
estadd scalar Crisis = 19

*** Column (2), Pre-2000: Global variables
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.country_id if year<=2000, robust cluster(period)
margins, dydx(dlogreal_pcredit  hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap) post
est store p3
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 13
estadd scalar Crisis = 12

*** Column (2), Post-1994: Global variables
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap i.country_id if year>=1994, robust cluster(period)
margins, dydx(dlogreal_pcredit  hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap) post
est store p4
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 13
estadd scalar Crisis = 15

*** Column (3), Pre-2000: Exuberance 
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap ind_hp_inc_exu ind_credit_gdp_exu i.country_id if year<=2000, robust cluster(period)
margins, dydx(dlogreal_pcredit  hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap ind_hp_inc_exu ind_credit_gdp_exu) post
est store p5
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 11
estadd scalar Crisis = 10

*** Column (3), Post-1994: Exuberance 
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap ind_hp_inc_exu ind_credit_gdp_exu i.country_id if year>=1994, robust cluster(period)
margins, dydx(dlogreal_pcredit  hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap global_credit_gap global_hp_gap ind_hp_inc_exu ind_credit_gdp_exu) post
est store p6
estadd scalar AUROC = r(area)
estadd scalar AUROC_se = r(se)
estadd scalar Countries = 12
estadd scalar Crisis = 14


cd "$outputTables"
esttab p1 p2 p3 p4 p5 p6 using TableF1.tex,se  ///
											   order(dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap global_credit_gap global_hp_gap ind_hp_inc_exu ind_credit_gdp_exu hp_inc_gap gdp_gap ) ///
											   star(* 0.1 ** 0.05 *** 0.01) obslast varwidth(30) wrap nomtitles ///
											   label scalars(Countries Crisis) ///
											   nodepvars nonotes replace
